<?php
   /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    */

    include "../include/costanti.php";
    include "../gUtil/DbManager.php";
    include "../classi/DocumentoContabile.php";
    include "../classi/GestoreStoricoOperazioni.php";
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb        = new DbManager($costantiDatabase);
    $datiGeecomAdmin = $geecomDb->leggiSingolaRiga("geec_prodotti", 2);
    $gestoreStoricoOperazioni   = new GestoreStoricoOperazioni($geecomDb,"Admin");
    $percorsoAreaAmministrativa = str_replace("../","",$datiGeecomAdmin["percorso"]);
    
    session_start();
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_ADD_SLASHES);
        $id         = filter_input(INPUT_POST, "id");
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_ADD_SLASHES);
        $id         = filter_input(INPUT_GET, "id");
    }

    $documento = new DocumentoContabile($geecomDb, $id);
    switch ($operazione) {
        case 'crea':
            $tipo = filter_input(INPUT_POST,"tipo",FILTER_SANITIZE_ADD_SLASHES);
            $documento->setTipo($tipo);
            $documento->setIdUtente(filter_input(INPUT_POST,"idUtente",FILTER_SANITIZE_NUMBER_INT));
            $documento->setOggetto(filter_input(INPUT_POST,"oggetto",FILTER_SANITIZE_ADD_SLASHES));
            $documento->setTesto(filter_input(INPUT_POST,"testo",FILTER_SANITIZE_ADD_SLASHES));
            $documento->setEntrataUscita(filter_input(INPUT_POST,"entrataUscita",FILTER_SANITIZE_ADD_SLASHES));
            $documento->setImponibile(filter_input(INPUT_POST,"imponibile",FILTER_SANITIZE_ADD_SLASHES));
            $documento->setIva(filter_input(INPUT_POST,"iva",FILTER_SANITIZE_ADD_SLASHES));
            $documento->setTotale(filter_input(INPUT_POST,"totale",FILTER_SANITIZE_ADD_SLASHES));
            $documento->setMetodoPagamento(filter_input(INPUT_POST,"metodoPagamento",FILTER_SANITIZE_ADD_SLASHES));
            $documento->setEtichetta(filter_input(INPUT_POST,"etichetta",FILTER_SANITIZE_ADD_SLASHES));
            $documento->setGiorniNecessari(filter_input(INPUT_POST,"giorniNecessari",FILTER_SANITIZE_NUMBER_INT));
            $documento->setGiorniValidita(filter_input(INPUT_POST,"giorniValidita",FILTER_SANITIZE_NUMBER_INT));
            $documento->setDataPagamento(filter_input(INPUT_POST,"dataPagamento",FILTER_SANITIZE_ADD_SLASHES));
            $documento->crea();
            
            $testoOperazione = "{$_SESSION["geecomAdmin_nomeCognome"]} ha creato il documento contabile di tipo {$documento->getTipo()} {$documento->getEntrataUscita()}. Id assegnato: {$documento->getId()}";
            $gestoreStoricoOperazioni->aggiungiElemento("creazioneDocumentoContabile", filter_var($testoOperazione,FILTER_SANITIZE_ADD_SLASHES));
            
            if($tipo=="prima nota") {
		header("Location: ../$percorsoAreaAmministrativa/documentiContabili.php?id={$documento->getId()}&tipo=prima nota&status=200");
            }
            else {
		header("Location: ../$percorsoAreaAmministrativa/creaDocumentoContabile.php?id={$documento->getId()}&status=200");
            }
            break;
        case 'modifica':
            $tipo = filter_input(INPUT_POST,"tipo",FILTER_SANITIZE_ADD_SLASHES);
            $documento->setTipo($tipo);
            $documento->setIdUtente(filter_input(INPUT_POST,"idUtente",FILTER_SANITIZE_NUMBER_INT));
            $documento->setOggetto(filter_input(INPUT_POST,"oggetto",FILTER_SANITIZE_ADD_SLASHES));
            $documento->setTesto(filter_input(INPUT_POST,"testo",FILTER_SANITIZE_ADD_SLASHES));
            $documento->setEntrataUscita(filter_input(INPUT_POST,"entrataUscita",FILTER_SANITIZE_ADD_SLASHES));
            $documento->setImponibile(filter_input(INPUT_POST,"imponibile",FILTER_SANITIZE_ADD_SLASHES));
            $documento->setIva(filter_input(INPUT_POST,"iva",FILTER_SANITIZE_ADD_SLASHES));
            $documento->setTotale(filter_input(INPUT_POST,"totale",FILTER_SANITIZE_ADD_SLASHES));
            $documento->setMetodoPagamento(filter_input(INPUT_POST,"metodoPagamento",FILTER_SANITIZE_ADD_SLASHES));
            $documento->setEtichetta(filter_input(INPUT_POST,"etichetta",FILTER_SANITIZE_ADD_SLASHES));
            $documento->setGiorniNecessari(filter_input(INPUT_POST,"giorniNecessari",FILTER_SANITIZE_NUMBER_INT));
            $documento->setGiorniValidita(filter_input(INPUT_POST,"giorniValidita",FILTER_SANITIZE_NUMBER_INT));
            $documento->setDataPagamento(filter_input(INPUT_POST,"dataPagamento",FILTER_SANITIZE_ADD_SLASHES));
            $documento->modifica();
            
            if($tipo=="prima nota") {
		header("Location: ../$percorsoAreaAmministrativa/documentiContabili.php?id={$documento->getId()}&tipo=prima nota&status=250");
            }
            else {
		header("Location: ../$percorsoAreaAmministrativa/creaDocumentoContabile.php?id={$documento->getId()}&status=250");
            }
            break;
        case 'elimina':
            $testoOperazione = "{$_SESSION["geecomAdmin_nomeCognome"]} ha eliminato il documento contabile con id {$documento->getId()}";
            $gestoreStoricoOperazioni->aggiungiElemento("eliminazioneDocumentoContabile", filter_var($testoOperazione,FILTER_SANITIZE_ADD_SLASHES));
            $documento->elimina();
            echo "ok";
            break;
        case 'duplica':
            $documento->caricaDatiDalDatabase();
            $nuovoId = $documento->duplica();
            header("Location: ../$percorsoAreaAmministrativa/creaDocumentoContabile.php?id={$nuovoId}&status=260");
            break;
        case 'creaVoceDocumento':
            $documento->caricaDatiDalDatabase(); // necessario per eseguire l'aggiornamento dell'importo
            
            $descrizione = filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES);
            $quantita    = filter_input(INPUT_POST,"quantita",FILTER_SANITIZE_NUMBER_INT);
            $prezzo      = filter_input(INPUT_POST,"prezzo",FILTER_SANITIZE_NUMBER_INT);
            $iva         = filter_input(INPUT_POST,"iva",FILTER_SANITIZE_NUMBER_INT);
            
            $documento->aggiungiVoceDocumento($descrizione,$quantita,$prezzo,$iva);
            $documento->aggiornaImportoTotale();
            
            if(isset($_POST["salvaVoce"]) && $_POST["salvaVoce"]=="si") {
            	$documento->salvaInVociPredefinite($descrizione,$prezzo,$iva);
            }
            
            header("Location: ../$percorsoAreaAmministrativa/creaDocumentoContabile.php?id={$documento->getId()}&status=270");           
            break;
        case 'stampaDatiVocePredefinita':
            $idVoce = filter_input(INPUT_POST,"idVoce",FILTER_SANITIZE_NUMBER_INT);
            $datiVoce = $geecomDb->leggiSingolaRiga("geecAd_vociDocumentiContabiliPredefinite",$idVoce);
            echo $datiVoce["prezzo"]."::".$datiVoce["iva"]."::".$datiVoce["descrizione"];
            break;
    }
